/**
 * Created by lei.wang_1 on 2016/7/11.
 */
appModule.directive("commentFocus", [function () {
    return {
        restrict: "A",
        link: function ($scope, element) {
            $scope.$watch('comment.isFocus', function (newV, oldV) {
                if (newV) {
                    var editor = element[0];
                    setTimeout(function () {
                        var sel, range;
                        range = document.createRange();
                        range.selectNodeContents(editor);
                        range.collapse(true);
                        range.setEnd(editor, editor.childNodes.length);
                        range.setStart(editor, editor.childNodes.length);
                        sel = window.getSelection();
                        sel.removeAllRanges();
                        sel.addRange(range);
                        var parent = $(editor).parent();
                        var scrollContainer = parent.closest('.inner');
                        parent.addClass('focus');
                        setTimeout(function () {
                            if (scrollContainer.length > 0) {
                                var padding = 15;
                                var delta = parent.height() + parent.offset().top - window.innerHeight + padding;
                                if (delta > 0) {
                                    scrollContainer.scrollTop(scrollContainer.scrollTop() + delta);
                                }
                            }
                        }, 300);

                    }, 1);
                    return;
                }
                element.parent().removeClass('focus');
            })
        }
    }
}]);